#!/bin/bash
set -e # exit on error
DATASET="tdiuc_absurd_val_absurd_k_minus_llava_5k"
MODEL_PATH=$1
if [ -z "$2" ]; then
    overwrite=False
else
    overwrite=$2
fi

bash scripts/v1_5/eval/tdiuc_absurd.sh $MODEL_PATH $overwrite

pred_data=$(python llava/eval/utils.py check_output_file_exists --output_file ${MODEL_PATH}/${DATASET}/merge.jsonl)

echo "pred_data: ${pred_data}"


question_file=<DATA_FOLDER>/TDIUC/val_absurd_k_minus_llava_5k.llava_eval.jsonl
image_folder="<DATA_FOLDER>"

MODEL_PATH_LOWER=$(echo "$MODEL_PATH" | tr '[:upper:]' '[:lower:]')
if [[ $MODEL_PATH_LOWER == *"qwen-vl"* ]]; then
    echo "qwen-vl in model path"

else
    echo "skip"
    
fi

python llava/eval/lave_metric.py  run_lave_metric \
      --gt_data  ${question_file} \
      --model_id models/Mistral/Mistral-7B-Instruct-v0.2 \
      --pred_data ${pred_data}  